;;  Programm:      ACM-FLAEMESS.LSP
;;  Befehlsaufruf: ACM-FLAEMESS
;;  Funktion:      Ermittelt mithilfe des Befehls UMGRENZUNG die Flche eines umgrenzten
;;                 Bereichs und schreibt ggf. den ermittelten Wert in die Zeichnung.
;;  Autor:         Gerhard Rampf
;;                 Kundenspezifische Anpassungen fr AutoCAD und ZWCAD
;;                 Liebigstr. 3 A
;;                 86399 Bobingen
;;                 E-Mail: rampf@geracad.de
;;  Datum:         13.02.2023
;;  Plattform:     Alle AutoCAD-Versionen ab Version 2005
(defun c:acm-flaemess ( / flm67 flm84 mlf01 mlf02 mlf03 mlf04 mlf05 mlf06 mlf07 mlf08 mlf09 mlf10 mlf11 mlf12 mlf13 mlf14 mlf15 mlf16 mlf17 mlf18)
    (defun mlf01 ( / flm13)
      (setq flm13 (strcase (getvar "PRODUCT")))
        (if
          (and
            (= flm13 "AUTOCAD")
            (getvar "HPDRAWORDER")
          )
            (setq flm14 T)
            (setq flm14 nil)
        )
        (if (not flm14)
          (alert "\042acm-flaemess\042 kann nur unter AutoCAD ab Version 2005 verwendet werden.")
        )
      flm14
    )
    (defun mlf02 (flm01 / )
        (if flm15
          (vl-catch-all-apply 'setvar (list "CMDECHO" flm15))
        )
        (if flm47
          (vl-catch-all-apply 'setvar (list "OSMODE" flm47))
        )
        (if flm50
          (vl-catch-all-apply 'setvar (list "CLAYER" flm50))
        )
        (if flm51
          (vl-catch-all-apply 'setvar (list "CECOLOR" flm51))
        )
        (if flm52
          (vl-catch-all-apply 'setvar (list "CELWEIGHT" flm52))
        )
        (if flm53
          (vl-catch-all-apply 'setvar (list "LWDISPLAY" flm53))
        )
      (if flm84 (setq *error* flm84))
      (vla-EndUndoMark (vla-get-ActiveDocument (vlax-get-acad-object)))
      (princ)
    )
    (defun mlf03 ( / flm15 flm16 flm17 flm18 flm19)
      (mlf06 1)
      (setq flm15 (getvar "CMDECHO"))
      (setvar "CMDECHO" 0)
        (if
          (and
            (setq flm16 (mlf07))
            (setq flm17 (mlf08 (itoa acm223flaemess185903) flm16))
          )
            (progn
              (setq flm18 (nth 4 (cadr flm17)))
                (if
                  (and
                    (= acm223flaemess185904 1)
                    (setq flm19 (mlf04))
                  )
                    (progn
                      (if (= acm223flaemess185905 1)
                        (mlf14 flm18 flm19 acm223flaemess185906 acm223flaemess185908 acm223flaemess185907)
                        (mlf13 flm18 flm19 acm223flaemess185906 acm223flaemess185908 acm223flaemess185907)
                      )
                    )
                    (prompt (strcat "\n" flm18 " "))
                )
            )
        )
      (setvar "CMDECHO" flm15)
    )
    (defun mlf04 ( / flm48)
      (initget 8)
      (getpoint "\nStartpunkt des Textes angeben: ")
    )
    (defun mlf05 (flm02 / flm20 flm21 flm22 flm23 flm24 flm25 flm26 flm27 flm28 flm29 flm30 flm14)
        (if (setq flm20 (mlf16))
          (progn
            (setq flm21 (load_dialog flm20))
            (vl-catch-all-apply 'vl-file-delete (list flm20))
              (if (not (new_dialog "acm232_03" flm21))
                (exit)
              )
            (setq flm22 (car flm02))
            (setq flm23 (mapcar 'strcase flm22))
            (setq flm24 (cadr flm02))
            (setq flm25 (mapcar 'strcase flm24))
            (setq flm26 256)
              (repeat 248
                (setq flm27 (cons (strcat "Farbe " (itoa (setq flm26 (1- flm26)))) flm27))
              )
            (start_list "pl_00")
            (mapcar 'add_list (list "0" "0.1" "0.12" "0.123" "0.1234" "0.12345" "0.123456" "0.1234567" "0.12345678"))
            (end_list)
            (set_tile "pl_00" (itoa acm223flaemess185902))
            (start_list "pl_01")
            (mapcar 'add_list (append (list "Rot" "Gelb" "Grn" "Cayn" "Blau" "Magenta" "Wei") flm27))
            (end_list)
            (set_tile "pl_01" (itoa (1- acm223flaemess185903)))
            (start_image "i_01")
            (fill_image 0 0 (dimx_tile "i_01") (dimy_tile "i_01") acm223flaemess185903)
            (end_image)
            (start_list "pl_03")
            (mapcar 'add_list (list "MText" "Text"))
            (end_list)
            (set_tile "pl_03" (itoa acm223flaemess185905))
            (start_list "pl_04")
            (mapcar 'add_list flm22)
            (end_list)
            (set_tile "pl_04" (itoa (vl-position (strcase acm223flaemess185906) flm23)))
            (start_list "pl_05")
            (mapcar 'add_list flm24)
            (end_list)
            (set_tile "pl_05" (itoa (vl-position (strcase acm223flaemess185907) flm25)))
            (set_tile "eb_00" (rtos acm223flaemess185901 2 (getvar "LUPREC")))
            (set_tile "eb_01" (rtos acm223flaemess185908))
            (set_tile "tg_01" (itoa acm223flaemess185904))
              (if (= acm223flaemess185904 0)
                (progn
                  (foreach tile (list "pl_03" "pl_04" "pl_05" "eb_01")
                    (mode_tile tile 1)
                  )
                )
              )
              (action_tile "pl_01" "(start_image \"i_01\")
                (fill_image 0 0 (dimx_tile \"i_01\") (dimy_tile \"i_01\") (1+ (atoi $value)))
                (end_image)"
              )
              (action_tile "tg_01" "(if (= (atoi $value) 0)
                (progn
                  (foreach tile (list \"pl_03\" \"pl_04\" \"pl_05\" \"eb_01\")
                    (mode_tile tile 1)
                  )
                )
                (progn
                  (foreach tile (list \"pl_03\" \"pl_04\" \"pl_05\" \"eb_01\")
                    (mode_tile tile 0)
                  )
                ))"
              )
              (action_tile "b_01" "(setq flm28 nil)
                (if
                  (and
                    (setq flm29 (distof (get_tile \"eb_00\")))
                    (> flm29 0.0)
                  )
                    (setq flm28 1)
                    (progn
                      (alert \"Ungltige Eingabe fr Ausgabefaktor.\")
                      (mode_tile \"eb_00\" 2)
                    )
                )
                (if (= flm28 1)
                  (progn
                    (setq flm28 nil)
                      (if
                        (and
                          (setq flm30 (distof (get_tile \"eb_01\")))
                          (> flm30 0.0)
                        )
                          (setq flm28 1)
                          (progn
                            (alert \"Ungltige Eingabe fr Hhe.\")
                            (mode_tile \"eb_01\" 2)
                          )
                      )
                  )
                )
                (if flm28
                  (progn
                      (setq flm14
                        (list
                          (setq acm223flaemess185901 flm29)
                          (setq acm223flaemess185902 (atoi (get_tile \"pl_00\")))
                          (setq acm223flaemess185903 (1+ (atoi (get_tile \"pl_01\"))))
                          (setq acm223flaemess185904 (atoi (get_tile \"tg_01\")))
                          (setq acm223flaemess185905 (atoi (get_tile \"pl_03\")))
                          (setq acm223flaemess185906 (nth (atoi (get_tile \"pl_04\")) flm22))
                          (setq acm223flaemess185907 (nth (atoi (get_tile \"pl_05\")) flm24))
                          (setq acm223flaemess185908 flm30)
                        )
                      )
                    (mlf06 1)
                    (done_dialog)
                  )
                )"
              )
            (action_tile "b_02" "(setq flm14 nil) (done_dialog)")
            (start_dialog)
            (unload_dialog flm21)
          )
        )
      flm14
    )
    (defun mlf06 (flm03 / flm22 flm23 flm24 flm25 flm43 flm44 flm45 flm46)
      (setq flm22 (mlf10))
      (setq flm23 (mapcar 'strcase flm22))
      (setq flm24 (mlf11))
      (setq flm25 (mapcar 'strcase flm24))
        (if
          (or
            (not (vl-position (type acm223flaemess185901) (list 'INT 'REAL)))
            (and
              (vl-position (type acm223flaemess185901) (list 'INT 'REAL))
              (<= acm223flaemess185901 0.0)
            )
          )
            (setq acm223flaemess185901 1.0)
        )
        (if (not (vl-position acm223flaemess185902 (list 0 1 2 3 4 5 6 7 8)))
          (setq acm223flaemess185902 2)
        )
        (if
          (or
            (/= (type acm223flaemess185903) 'INT)
            (and
              (= (type acm223flaemess185903) 'INT)
              (or
                (< acm223flaemess185903 1)
                (> acm223flaemess185903 255)
              )
            )
          )
            (setq acm223flaemess185903 3)
        )
        (if (not (vl-position acm223flaemess185904 (list 0 1)))
          (setq acm223flaemess185904 0)
        )
        (if (not (vl-position acm223flaemess185905 (list 0 1)))
          (setq acm223flaemess185905 0)
        )
        (if
          (or
            (/= (type acm223flaemess185906) 'STR)
            (and
              (= (type acm223flaemess185906) 'STR)
              (not (vl-position (strcase acm223flaemess185906) flm23))
            )
          )
            (setq acm223flaemess185906 (getvar "CLAYER"))
        )
        (if
          (or
            (/= (type acm223flaemess185907) 'STR)
            (and
              (= (type acm223flaemess185907) 'STR)
              (not (vl-position (strcase acm223flaemess185907) flm25))
            )
          )
            (setq acm223flaemess185907 (getvar "TEXTSTYLE"))
        )
        (if
          (or
            (not (vl-position (type acm223flaemess185908) (list 'INT 'REAL)))
            (and
              (vl-position (type acm223flaemess185908) (list 'INT 'REAL))
              (<= acm223flaemess185908 0.0)
            )
          )
            (setq acm223flaemess185908 (abs (getvar "TEXTSIZE")))
        )
        (if (not (vl-position acm223flaemess185909 (list 0 1)))
          (setq acm223flaemess185909 0)
        )
        (if (not (vl-position acm223flaemess185910 (list 0 1)))
          (setq acm223flaemess185910 0)
        )
        (if
          (or
            (/= (type acm223flaemess185911) 'STR)
            (and
              (= (type acm223flaemess185911) 'STR)
              (or
                (> (strlen acm223flaemess185911) 50)
                (= (vl-string-trim " " acm223flaemess185911) "")
              )
            )
          )
            (progn
              (setq acm223flaemess185911 "")
              (setq acm223flaemess185909 0)
            )
        )
        (if
          (or
            (/= (type acm223flaemess185912) 'STR)
            (and
              (= (type acm223flaemess185912) 'STR)
              (or
                (> (strlen acm223flaemess185912) 50)
                (= (vl-string-trim " " acm223flaemess185912) "")
              )
            )
          )
            (progn
              (setq acm223flaemess185912 "")
              (setq acm223flaemess185910 0)
            )
        )
        (if (= acm223flaemess185904 1)
          (setq flm43
            (strcat
              ", Typ = "
              (nth acm223flaemess185905 (list "MText" "Text"))
              ", Layer = "
              (mlf15 acm223flaemess185906 15)
              ", Stil = "
              (mlf15 acm223flaemess185907 15)
              ", Hhe = "
              (rtos acm223flaemess185908)
            )
          )
          (setq flm43 "")
        )
        (if
          (and
            (= acm223flaemess185909 1)
            (/= (vl-string-trim " " acm223flaemess185911) "")
          )
            (setq flm44 (strcat ", Suffix = " acm223flaemess185911))
            (setq flm44 "")
        )
        (if
          (and
            (= acm223flaemess185910 1)
            (/= (vl-string-trim " " acm223flaemess185912) "")
          )
            (setq flm45 (strcat ", Prfix = " acm223flaemess185912))
            (setq flm45 "")
        )
        (setq flm46
          (strcat
            "\nAktuelle Einstellungen: Ausgabefaktor = "
            (rtos acm223flaemess185901 2 (getvar "LUPREC"))
            ", Genauigkeit = "
            (nth acm223flaemess185902 (list "0" "0.1" "0.12" "0.123" "0.1234" "0.12345" "0.123456" "0.1234567" "0.12345678"))
            flm45
            flm44
            ", Kontrollfarbe = "
              (if (< acm223flaemess185903 8)
                (nth (1- acm223flaemess185903) (list "Rot" "Gelb" "Grn" "Cyan" "Blau" "Magenta" "Wei"))
                (strcat "Farbe " (itoa acm223flaemess185903))
              )
            ", Text einfgen = "
            (nth acm223flaemess185904 (list "Nein" "Ja"))
            flm43
          )
        )
        (if (> flm03 0)
          (prompt flm46)
        )
      (list flm22 flm24)
    )
    (defun mlf07 ( / flm47 flm48)
      (setq flm47 (getvar "OSMODE"))
      (setvar "OSMODE" 0)
      (initget 8 "Einstellungen")
      (setq flm48 (getpoint "\nInternen Punkt angeben oder [Einstellungen]: "))
        (while (= (type flm48) 'STR)
          (mlf05 (mlf06 0))
          (initget 8 "Einstellungen")
          (setq flm48 (getpoint "\nInternen Punkt angeben oder [Einstellungen]: "))
        )
      (setvar "OSMODE" flm47)
      flm48
    )
    (defun mlf08 (flm04 flm05 / flm49 flm50 flm51 flm52 flm53 flm54 flm55 flm56 flm57 flm58 flm59)
      (setq flm49 (mlf09))
      (setq flm50 (getvar "CLAYER"))
      (setq flm51 (getvar "CECOLOR"))
      (setq flm52 (getvar "CELWEIGHT"))
      (setq flm53 (getvar "LWDISPLAY"))
      (setvar "CLAYER" flm49)
      (setvar "CECOLOR" flm04)
      (setvar "CELWEIGHT" 70)
      (setvar "LWDISPLAY" 1)
      (vl-cmdf "._-boundary" "_advanced" "_o" "_p" "_i" "_no" "" "" flm05 "")
      (setvar "CELWEIGHT" flm52)
      (setvar "CECOLOR" flm51)
      (setvar "CLAYER" flm50)
        (if
          (and
            (setq flm54 (ssget "_x" (list (cons 8 flm49) (cons 410 (getvar "CTAB")))))
            (= (sslength flm54) 1)
            (vl-string-search "POLYLINE" (strcase (vlax-get (setq flm55 (vlax-ename->vla-object (ssname flm54 0))) 'ObjectName)))
          )
            (progn
              (setq flm56 (vlax-get flm55 'Area))
              (setq flm57 (mlf18 flm56))
              (vl-catch-all-apply 'vla-Delete (list flm55))
                (if (setq flm58 (ssget "_x" (list (cons 8 flm49) (cons 410 (getvar "CTAB")))))
                  (progn
                    (setq flm59 -1)
                      (repeat (sslength flm58)
                        (setq flm59 (1+ flm59))
                        (vl-catch-all-apply 'vla-Delete (list (vlax-ename->vla-object (ssname flm58 flm59))))
                      )
                  )
                )
              (vl-catch-all-apply 'vla-Delete (list (vlax-ename->vla-object (tblobjname "LAYER" flm49))))
            )
            (progn
                (if (setq flm58 (ssget "_x" (list (cons 8 flm49) (cons 410 (getvar "CTAB")))))
                  (progn
                    (setq flm59 -1)
                      (repeat (sslength flm58)
                        (setq flm59 (1+ flm59))
                        (vl-catch-all-apply 'vla-Delete (list (vlax-ename->vla-object (ssname flm58 flm59))))
                      )
                  )
                )
              (vl-catch-all-apply 'vla-Delete (list (vlax-ename->vla-object (tblobjname "LAYER" flm49))))
            )
        )
      (setvar "LWDISPLAY" flm53)
        (if flm57
          (list flm56 flm57)
          nil
        )
    )
    (defun mlf09 ( / flm60 flm61)
      (setq flm60 0)
        (while (tblsearch "LAYER" (setq flm61 (strcat "tl" (itoa flm60))))
          (setq flm60 (1+ flm60))
        )
      (entmake (list (cons 0 "LAYER") (cons 100 "AcDbSymbolTableRecord") (cons 100 "AcDbLayerTableRecord") (cons 2 flm61) (cons 62 7) (cons 70 0)))
      flm61
    )
    (defun mlf10 ( / flm62 flm61 flm63)
      (setq flm62 (vla-get-Layers (vla-get-ActiveDocument (vlax-get-acad-object))))
        (vlax-for lay flm62
          (if (not (vl-string-search "|" (setq flm61 (vlax-get lay 'Name))))
            (setq flm63 (cons flm61 flm63))
          )
        )
      (acad_strlsort flm63)
    )
    (defun mlf11 ( / flm64 flm65 flm66)
      (setq flm64 (vla-get-TextStyles (vla-get-ActiveDocument (vlax-get-acad-object))))
        (vlax-for lay flm64
          (if (not (vl-string-search "|" (setq flm65 (vlax-get lay 'Name))))
            (setq flm66 (cons flm65 flm66))
          )
        )
      (acad_strlsort flm66)
    )
    (defun mlf12 ( / flm67 flm68)
      (setq flm67 (vla-get-ActiveDocument (vlax-get-acad-object)))
        (if (< (getvar "TILEMODE") 1)
          (progn
            (if (= (vla-get-MSpace flm67) :vlax-true)
              (setq flm68 (vla-get-ModelSpace flm67))
              (setq flm68 (vla-get-PaperSpace flm67))
            )
          )
          (setq flm68 (vla-get-ModelSpace flm67))
        )
      flm68
    )
    (defun mlf13 (flm06 flm05 flm07 flm08 flm09 / flm50 flm69 flm48 flm70 flm71 flm72)
      (setq flm50 (getvar "CLAYER"))
      (setq flm69 (mlf12))
      (setq flm48 (vlax-3D-point flm05))
        (if (= (vla-get-Lock (setq flm70 (vlax-ename->vla-object (tblobjname "LAYER" flm07)))) :vlax-true)
          (progn
            (setq flm71 1)
            (vla-put-Lock flm70 :vlax-false)
          )
        )
      (setvar "CLAYER" flm07)
      (setq flm72 (vla-AddMText flm69 flm48 0 flm06))
      (vl-catch-all-apply 'vlax-put (list flm72 'AttachmentPoint 7))
      (vl-catch-all-apply 'vla-Move (list flm72 (vlax-3D-point (vlax-get flm72 'InsertionPoint)) flm48))
      (vl-catch-all-apply 'vlax-put (list flm72 'StyleName flm09))
      (vl-catch-all-apply 'vlax-put (list flm72 'Height flm08))
      (setvar "CLAYER" flm50)
        (if flm71
          (vla-put-Lock flm70 :vlax-true)
        )
    )
    (defun mlf14 (flm06 flm05 flm07 flm08 flm09 / flm50 flm69 flm48 flm70 flm71 flm73)
      (setq flm50 (getvar "CLAYER"))
      (setq flm69 (mlf12))
      (setq flm48 (vlax-3D-point flm05))
        (if (= (vla-get-Lock (setq flm70 (vlax-ename->vla-object (tblobjname "LAYER" flm07)))) :vlax-true)
          (progn
            (setq flm71 1)
            (vla-put-Lock flm70 :vlax-false)
          )
        )
      (setvar "CLAYER" flm07)
      (setq flm73 (vla-AddText flm69 flm06 flm48 flm08))
      (vl-catch-all-apply 'vlax-put (list flm73 'Alignment 0))
      (vl-catch-all-apply 'vlax-put (list flm73 'StyleName flm09))
      (setvar "CLAYER" flm50)
        (if flm71
          (vla-put-Lock flm70 :vlax-true)
        )
    )
    (defun mlf15 (flm10 flm11 / flm77 flm74 flm75 flm76)
      (setq flm74 (strlen flm10))
        (if (> flm74 flm11)
          (progn
            (setq flm75 (substr flm10 1 (/ (- flm11 3) 2)))
            (setq flm76 (substr flm10 (- flm74 (1- (/ (- flm11 3) 2)))))
            (setq flm77 (strcat flm75 "\056\056\056" flm76))
          )
        )
        (if flm77
          flm77
          flm10
        )
    )
    (defun mlf16 ( / flm78 flm79 flm80)
      (if
        (and
          (setq flm78 (vl-filename-mktemp "acm.dcl"))
          (setq flm79 (open flm78 "w"))
        )
          (progn
            (setq flm80
              (list
                "acm232_03"
                ":dialog{label=\042Einstellungen\042;"
                ":spacer{height=0;}"
                ":boxed_column{label=\042Ausgabeoptionen\042;"
                ":edit_box{key=\042eb_00\042;label=\042&Faktor:\042;edit_width=16.1;allow_accept=true;}"
                ":popup_list{key=\042pl_00\042;label=\042&Genauigkeit:\042;edit_width=15.4;}}"
                ":spacer{height=0.2;}"
                ":boxed_column{label=\042Kontrolloption\042;"
                ":row{"
                ":popup_list{key=\042pl_01\042;label=\042F&arbe:\042;width=26;edit_width=14.5;}"
                ":image{key=\042i_01\042;height=1;}}}"
                ":spacer{height=0;}"
                ":boxed_column{label=\042Textoptionen\042;"
                ":toggle{key=\042tg_01\042;label=\042T&ext einfgen\042;}"
                ":row{"
                ":spacer{width=1.1;}"
                ":column{width=31;"
                ":popup_list{key=\042pl_03\042;label=\042&Typ:\042;edit_width=19;}"
                ":popup_list{key=\042pl_04\042;label=\042&Layer:\042;edit_width=19;}"
                ":popup_list{key=\042pl_05\042;label=\042&Stil:\042;edit_width=19;}"
                ":edit_box{key=\042eb_01\042;label=\042&Hhe:\042;edit_width=19.8;allow_accept=true;}}}}"
                ":spacer{height=0.4;}"
                ":row{"
                ":spacer{width=7;}"
                ":column{width=0;"
                ":button{key=\042b_01\042;label=\042OK\042;is_default=true;}"
                ":button{key=\042b_02\042;label=\042Abbrechen\042;is_cancel=true;}}"
                ":spacer{width=7;}}}"
              )
            )
              (while flm80
                (write-line (car flm80) flm79)
                (setq flm80 (cdr flm80))
              )
            (setq flm79 (close flm79))
            flm78
          )
          nil
      )
    )
    (defun mlf17 ( / flm78 flm79 flm81 flm80)
      (if
        (and
          (setq flm78 (vl-filename-mktemp "acm.dcl"))
          (setq flm79 (open flm78 "w"))
        )
          (progn
              (if (= acm223flaemess185904 0)
                (progn
                  (setq flm81 "Ausgabetext")
                  (setq flm82 "Schlieen")
                )
                (progn
                  (setq flm81 "Einfgetext")
                  (setq flm82 "Einfgen")
                )
              )
            (setq flm80
              (list
                "acm232_04"
                (strcat ":dialog{label=\042" flm81 "\042;")
                ":spacer{height=0.4;}"
                ":text{key=\042t_01\042;}"
                ":spacer{height=0.4;}"
                ":row{"
                ":toggle{key=\042tg_01\042;label=\042&Prfix:\042;width=11;}"
                ":edit_box{key=\042eb_01\042;width=22;edit_width=17;edit_limit=50;action=\042(mlf19)\042;}}"
                ":row{"
                ":toggle{key=\042tg_02\042;label=\042&Suffix:\042;width=11;}"
                ":edit_box{key=\042eb_02\042;width=22;edit_width=17;edit_limit=50;action=\042(mlf20)\042;}}"
                ":spacer{height=0.4;}"
                  (if (= acm223flaemess185904 1)
                    ":text{label=\042Einzufgender Text:\042;}"
                    ":text{label=\042Auszugebender Text:\042;}"
                  )
                ":edit_box{key=\042eb_03\042;allow_accept=true;}"
                ":spacer{height=0.8;}"
                ":row{"
                ":spacer{width=1;}"
                ":column{width=0;"
                (strcat ":button{key=\042b_01\042;label=\042" flm82 "\042;is_default=true;}")
                  (if (= acm223flaemess185904 1)
                    ":button{key=\042b_02\042;label=\042Abbrechen\042;is_cancel=true;}"
                    ""
                  )
                "}"
                ":spacer{width=1;}}}"
              )
            )
              (while flm80
                (write-line (car flm80) flm79)
                (setq flm80 (cdr flm80))
              )
            (setq flm79 (close flm79))
            flm78
          )
          nil
      )
    )
    (defun mlf18 (flm12 / flm20 flm21 flm14 mlf19 mlf20)
        (defun mlf19 ( / )
          (setq acm223flaemess185912 $value)
          (set_tile "eb_03" (strcat acm223flaemess185912 flm83 (nth acm223flaemess185909 (list "" acm223flaemess185911))))
        )
        (defun mlf20 ( / )
          (setq acm223flaemess185911 $value)
          (set_tile "eb_03" (strcat (nth acm223flaemess185910 (list "" (get_tile "eb_01"))) flm83 (get_tile "eb_02")))
        )
        (if (setq flm20 (mlf17))
          (progn
            (setq flm21 (load_dialog flm20))
            (vl-catch-all-apply 'vl-file-delete (list flm20))
              (if (not (new_dialog "acm232_04" flm21))
                (exit)
              )
            (set_tile "t_01" (strcat "Flche = " (setq flm83 (rtos (* flm12 acm223flaemess185901) (getvar "LUNITS") acm223flaemess185902))))
            (set_tile "tg_01" (itoa acm223flaemess185910))
            (set_tile "tg_02" (itoa acm223flaemess185909))
              (if (= acm223flaemess185910 0)
                (mode_tile "eb_01" 1)
              )
              (if (= acm223flaemess185909 0)
                (mode_tile "eb_02" 1)
              )
            (set_tile "eb_01" acm223flaemess185912)
            (set_tile "eb_02" acm223flaemess185911)
            (set_tile "eb_03" (strcat (nth acm223flaemess185910 (list "" acm223flaemess185912)) flm83 (nth acm223flaemess185909 (list "" acm223flaemess185911))))
              (action_tile "tg_01" "(mode_tile \"eb_01\" (nth (setq acm223flaemess185910 (atoi $value)) (list 1 0)))
                (set_tile \"eb_03\" (strcat (nth acm223flaemess185910 (list \"\" (get_tile \"eb_01\"))) flm83 (nth acm223flaemess185909 (list \"\" (get_tile \"eb_02\")))))"
              )
              (action_tile "tg_02" "(mode_tile \"eb_02\" (nth (setq acm223flaemess185909 (atoi $value)) (list 1 0)))
                (set_tile \"eb_03\" (strcat (nth acm223flaemess185910 (list \"\" (get_tile \"eb_01\"))) flm83 (nth acm223flaemess185909 (list \"\" (get_tile \"eb_02\")))))"
              )
              (action_tile "b_01" "(setq flm14
                (list
                  (setq acm223flaemess185910 (atoi (get_tile \"tg_01\")))
                  (setq acm223flaemess185909 (atoi (get_tile \"tg_02\")))
                  (setq acm223flaemess185912 (get_tile \"eb_01\"))
                  (setq acm223flaemess185911 (get_tile \"eb_02\"))
                  (vl-string-trim \" \" (get_tile \"eb_03\"))
                ))
                (done_dialog)"
              )
            (action_tile "b_02" "(setq flm14 nil)")
            (start_dialog)
            (unload_dialog flm21)
          )
        )
      flm14
    )
  (if (mlf01)
    (progn
      (vl-load-com)
      (setq flm67 (vla-get-ActiveDocument (vlax-get-acad-object)))
      (setq flm84 *error*)
      (setq *error* mlf02)
      (vla-EndUndoMark flm67)
      (vla-StartUndoMark flm67)
      (mlf03)
        (if flm84
          (setq *error* flm84)
          (setq *error* nil)
        )
      (vla-EndUndoMark flm67)
    )
  )
  (princ)
)
(terpri)
(princ "\nAutoLISP-Tool ACM-FLAEMESS (Copyright  2023 Gerhard Rampf) geladen.")
(princ "\nRufen Sie den Befehl mit ACM-FLAEMESS auf.")
